/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericCellSpinner;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.EthernetConfigurePanel;
import DE.siemens.ad.logo.dialog.comp.IPAddressJTextField;
import DE.siemens.ad.logo.dialog.comp.IndexedJTablePanel;
import DE.siemens.ad.logo.dialog.comp.SpinnerCellEditor;
import DE.siemens.ad.logo.model.EthernetConnection;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionConfigurePanel
extends DataInputPanel {
    private EthernetConnection fEthernetConnection;
    private DataTransferJTablePanel fTablePanel;
    private JTextField fClientLocalTsap;
    private JTextField fClientRemoteTsap;
    private EditableNumericSpinner fAliveInterval;
    private JTextField fServerLocalTsap;
    private JTextField fServerRemoteTsap;
    private IPAddressJTextField fClientRemoteIP;
    private IPAddressJTextField fAcceptedIP;
    private JCheckBox fOPCheckBox;
    private JCheckBox fAcceptAllIP;
    private JPanel fParameterPanel;
    private JRadioButton fClientButton;
    private JRadioButton fServerButton;
    private CardLayout fParameterPanelLayout;
    private String sLocalProperties = Language.getString("ethernet.connectionConfigurePanel.localProperties", "Local Properties");
    private String sRemoteProperties = Language.getString("ethernet.connectionConfigurePanel.remoteProperties", "Remote Properties");
    private String sClient = Language.getString("ethernet.connectionConfigurePanel.client", "Client");
    private String sServer = Language.getString("ethernet.connectionConfigurePanel.server", "Server");
    private String READ = Language.getString("dialog.setClock.readBtn", "Read");
    private String WRITE = Language.getString("dialog.setClock.writeBtn", "Write");
    private BorderJPanel fKeepAlivePanel;
    private JCheckBox fEnableKeepAlive;
    private JTable fTable;
    private String sModuleIPAddress;
    private Vector<EthernetConnection> fDataVector;
    private int fVMSize;
    private static final int TSAP_LENGTH = 5;
    private static final String OP_TSAP = "02.00";
    private static final int MAXIMUM_DB_SIZE = 16000;
    private static final int MAXIMUM_DBB_SIZE = 65535;
    private static final int MAXIMUM_REMOTE_ADDRESS = 65535;
    private static final int CORRECT_ADDRESS = 0;
    private static final int WRONG_ADDRESS_FORMAT = 1;
    private static final int WRONG_ADDRESS_RANGE = 2;
    private static final int WRONG_TRANSFERRED_AREA = 3;
    private Hardware fHardware;

    public ConnectionConfigurePanel(EthernetConnection connection, Vector connVector, Hardware hw, String moduleIPAddress) {
        this.fHardware = hw;
        this.fDataVector = connVector;
        this.fEthernetConnection = connection;
        this.fVMSize = this.fHardware.getIntProperty("nStartAddress");
        this.initialize();
        this.sModuleIPAddress = moduleIPAddress;
    }

    public EthernetConnection getEthernetConnection() {
        return this.fEthernetConnection;
    }

    public void setEthernetConnection(EthernetConnection connection, Vector connVector, String moduleIPAddress) {
        this.fDataVector = connVector;
        this.fEthernetConnection = connection;
        this.setName(this.fEthernetConnection.toString());
        this.sModuleIPAddress = moduleIPAddress;
    }

    private void initialize() {
        this.setName(this.fEthernetConnection.toString());
        this.setLayout(new BorderLayout(0, 5));
        this.setPreferredSize(new Dimension(580, 560));
        this.fParameterPanelLayout = new CardLayout();
        this.fParameterPanel = new JPanel(this.fParameterPanelLayout);
        this.fParameterPanel.add((Component)this.getClientPanel(), "Client");
        this.fParameterPanel.add((Component)this.getServerPanel(), "Server");
        this.add((Component)this.getConnectionTypePanel(), "North");
        this.add((Component)this.fParameterPanel, "Center");
        this.add((Component)this.getKeepAlivePanel(), "South");
    }

    private JPanel getServerPanel() {
        JPanel serverPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        serverPanel.add((Component)this.getServerPropertiesPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        serverPanel.add((Component)new JPanel(), constraints);
        return serverPanel;
    }

    private JPanel getClientPanel() {
        JPanel clientPanel = new JPanel();
        clientPanel.setLayout(new BorderLayout(0, 0));
        clientPanel.add((Component)this.getClientPropertiesPanel(), "North");
        clientPanel.add((Component)this.getDataTransferPanel(), "Center");
        return clientPanel;
    }

    private BorderJPanel getKeepAlivePanel() {
        if (this.fKeepAlivePanel == null) {
            this.fKeepAlivePanel = new BorderJPanel(new GridBagLayout());
            this.fKeepAlivePanel.setTitle(Language.getString("ethernet.connectionConfigurePanel.keepAlive", "Keep Alive"));
            this.fAliveInterval = new EditableNumericSpinner();
            this.fAliveInterval.setMinMax(0, 180);
            this.fAliveInterval.setIncrement(1);
            this.fAliveInterval.setEnabled(false);
            this.fEnableKeepAlive = new JCheckBox(Language.getString("ethernet.connectionConfigurePanel.enableAlive", "Enable the Keep Alive function for this connection."));
            this.fEnableKeepAlive.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ConnectionConfigurePanel.this.fAliveInterval.setValue(5);
                    } else {
                        ConnectionConfigurePanel.this.fAliveInterval.setValue(0);
                    }
                }
            });
            JLabel aliveLabel = new JLabel(Language.getString("ethernet.connectionConfigurePanel.aliveInterval", "Keep Alive  Interval"));
            JLabel timeUnit = new JLabel(Language.getString("ethernet.connectionConfigurePanel.timeUnit", "Seconds"));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 5, 0, 0);
            constraints.gridwidth = 3;
            constraints.gridx = 0;
            constraints.gridy = 0;
            this.fKeepAlivePanel.add((Component)this.fEnableKeepAlive, constraints);
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            this.fKeepAlivePanel.add((Component)new JPanel(), constraints);
            constraints.gridwidth = 1;
            constraints.weightx = 0.0;
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.insets = new Insets(10, 26, 0, 0);
            this.fKeepAlivePanel.add((Component)aliveLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.insets = new Insets(5, 5, 0, 0);
            this.fKeepAlivePanel.add((Component)this.fAliveInterval, constraints);
            constraints.gridx = 2;
            constraints.gridy = 1;
            constraints.insets = new Insets(10, 5, 10, 0);
            this.fKeepAlivePanel.add((Component)timeUnit, constraints);
        }
        return this.fKeepAlivePanel;
    }

    private JPanel getConnectionTypePanel() {
        JPanel fConnectionTypePanel = new JPanel(new GridLayout(2, 1));
        ButtonGroup connectionGroup = new ButtonGroup();
        this.fClientButton = new JRadioButton(Language.getString("ethernet.connectionConfigurePanel.clientConnettion", "Client Connection: request data transfer between the local PLC and a remote PLC"));
        this.fServerButton = new JRadioButton(Language.getString("ethernet.connectionConfigurePanel.serverConnettion", "Server Connection: respond to connection requests from remote clients"));
        this.fClientButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (ConnectionConfigurePanel.this.fEthernetConnection.getLocalTsap() == null || ConnectionConfigurePanel.this.fEthernetConnection.getLocalTsap().equals(ConnectionConfigurePanel.OP_TSAP)) {
                        ConnectionConfigurePanel.this.fClientLocalTsap.setText(EthernetConfigurePanel.getFreeLocalTsap(ConnectionConfigurePanel.this.fDataVector));
                    } else {
                        ConnectionConfigurePanel.this.fClientLocalTsap.setText(ConnectionConfigurePanel.this.fEthernetConnection.getLocalTsap());
                    }
                    ConnectionConfigurePanel.this.fParameterPanelLayout.show(ConnectionConfigurePanel.this.fParameterPanel, "Client");
                }
            }
        });
        this.fServerButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (ConnectionConfigurePanel.this.fEthernetConnection.getLocalTsap() == null) {
                        ConnectionConfigurePanel.this.fServerLocalTsap.setText(EthernetConfigurePanel.getFreeLocalTsap(ConnectionConfigurePanel.this.fDataVector));
                    } else {
                        ConnectionConfigurePanel.this.fServerLocalTsap.setText(ConnectionConfigurePanel.this.fEthernetConnection.getLocalTsap());
                        if (ConnectionConfigurePanel.this.fEthernetConnection.getLocalTsap().equals(ConnectionConfigurePanel.OP_TSAP)) {
                            ConnectionConfigurePanel.this.fOPCheckBox.setSelected(true);
                        } else {
                            ConnectionConfigurePanel.this.fOPCheckBox.setSelected(false);
                            ConnectionConfigurePanel.this.fOPCheckBox.setEnabled(!ConnectionConfigurePanel.this.isOPUsed());
                        }
                    }
                    ConnectionConfigurePanel.this.fParameterPanelLayout.show(ConnectionConfigurePanel.this.fParameterPanel, "Server");
                }
            }
        });
        connectionGroup.add(this.fClientButton);
        connectionGroup.add(this.fServerButton);
        fConnectionTypePanel.add(this.fClientButton);
        fConnectionTypePanel.add(this.fServerButton);
        return fConnectionTypePanel;
    }

    private JPanel getClientPropertiesPanel() {
        JPanel propertiesPanel = new JPanel(new GridLayout(1, 2));
        propertiesPanel.add(this.getClientLocalPanel());
        propertiesPanel.add(this.getClientRemotePanel());
        return propertiesPanel;
    }

    private JPanel getServerPropertiesPanel() {
        JPanel propertiesPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 0;
        propertiesPanel.add((Component)this.getServerLocalPanel(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        propertiesPanel.add((Component)this.getServerRemotePanel(), constraints);
        return propertiesPanel;
    }

    private BorderJPanel getClientLocalPanel() {
        BorderJPanel local = new BorderJPanel();
        local.setLayout(new GridBagLayout());
        local.setTitle(this.sLocalProperties + " (" + this.sClient + ")");
        this.fClientLocalTsap = new JTextField();
        this.fClientLocalTsap.setColumns(8);
        this.fClientLocalTsap.setEditable(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(10, 10, 5, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        local.add((Component)new JLabel(Language.getString("ethernet.connectionConfigurePanel.tsap", "TSAP:")), constraints);
        constraints.insets = new Insets(5, 5, 5, 0);
        constraints.gridx = 1;
        constraints.gridy = 0;
        local.add((Component)this.fClientLocalTsap, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        local.add((Component)new JPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weighty = 1.0;
        constraints.weightx = 0.0;
        local.add((Component)new JPanel(), constraints);
        return local;
    }

    private BorderJPanel getClientRemotePanel() {
        BorderJPanel remote = new BorderJPanel();
        remote.setLayout(new GridBagLayout());
        remote.setTitle(this.sRemoteProperties + " (" + this.sServer + ")");
        this.fClientRemoteTsap = new JTextField();
        this.fClientRemoteTsap.setColumns(5);
        this.fClientRemoteIP = new IPAddressJTextField();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 3;
        constraints.anchor = 18;
        constraints.insets = new Insets(10, 10, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        remote.add((Component)new JLabel(Language.getString("ethernet.connectionConfigurePanel.tsap", "TSAP:")), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 5, 0, 0);
        remote.add((Component)this.fClientRemoteTsap, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(10, 10, 10, 0);
        remote.add((Component)new JLabel(Language.getString("ethernet.tcpSettingPanel.columnIPAddress", "IP Address") + ":"), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets = new Insets(5, 5, 10, 0);
        remote.add((Component)this.fClientRemoteIP, constraints);
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        remote.add((Component)new JPanel(), constraints);
        return remote;
    }

    private BorderJPanel getServerLocalPanel() {
        BorderJPanel server = new BorderJPanel();
        server.setLayout(new GridBagLayout());
        server.setTitle(this.sLocalProperties + " (" + this.sServer + ")");
        this.fServerLocalTsap = new JTextField();
        this.fServerLocalTsap.setColumns(5);
        this.fServerLocalTsap.setEditable(false);
        this.fOPCheckBox = new JCheckBox(Language.getString("ethernet.connectionConfigurePanel.op", "Connect with an Operator Panel (OP)"));
        this.fOPCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConnectionConfigurePanel.this.fServerLocalTsap.setText(ConnectionConfigurePanel.OP_TSAP);
                } else if (ConnectionConfigurePanel.this.fEthernetConnection.getLocalTsap() != null && !ConnectionConfigurePanel.this.fEthernetConnection.getLocalTsap().equals(ConnectionConfigurePanel.OP_TSAP)) {
                    ConnectionConfigurePanel.this.fServerLocalTsap.setText(ConnectionConfigurePanel.this.fEthernetConnection.getLocalTsap());
                } else {
                    ConnectionConfigurePanel.this.fServerLocalTsap.setText(EthernetConfigurePanel.getFreeLocalTsap(ConnectionConfigurePanel.this.fDataVector));
                }
            }
        });
        this.fAcceptAllIP = new JCheckBox(Language.getString("ethernet.connectionConfigurePanel.acceptAllRequests", "Accept all connection requests"));
        this.fAcceptAllIP.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConnectionConfigurePanel.this.fAcceptedIP.resetIP();
                    ConnectionConfigurePanel.this.fAcceptedIP.setEnabled(false);
                } else {
                    ConnectionConfigurePanel.this.fAcceptedIP.setEnabled(true);
                }
            }
        });
        this.fAcceptedIP = new IPAddressJTextField();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(10, 10, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        server.add((Component)new JLabel(Language.getString("ethernet.connectionConfigurePanel.tsap", "TSAP:")), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 5, 0, 0);
        server.add((Component)this.fServerLocalTsap, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(5, 2, 0, 0);
        server.add((Component)this.fOPCheckBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(5, 5, 0, 0);
        server.add((Component)this.fAcceptAllIP, constraints);
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.insets = new Insets(5, 4, 0, 0);
        constraints.gridwidth = 1;
        server.add((Component)new JLabel(Language.getString("ethernet.connectionConfigurePanel.acceptOneIP", "Accept connection requests from the following client only:")), constraints);
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.insets = new Insets(2, 5, 0, 0);
        server.add((Component)this.fAcceptedIP, constraints);
        return server;
    }

    private BorderJPanel getServerRemotePanel() {
        BorderJPanel remote = new BorderJPanel();
        remote.setLayout(new GridBagLayout());
        remote.setTitle(this.sRemoteProperties + " (" + this.sClient + ")");
        this.fServerRemoteTsap = new JTextField();
        this.fServerRemoteTsap.setColumns(5);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(10, 10, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        remote.add((Component)new JLabel(Language.getString("ethernet.connectionConfigurePanel.tsap", "TSAP:")), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 5, 0, 0);
        remote.add((Component)this.fServerRemoteTsap, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        remote.add((Component)new JPanel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        remote.add((Component)new JPanel(), constraints);
        return remote;
    }

    private BorderJPanel getDataTransferPanel() {
        BorderJPanel dataTransferPanel = new BorderJPanel();
        dataTransferPanel.setLayout(new BorderLayout());
        dataTransferPanel.setTitle(Language.getString("ethernet.connectionConfigurePanel.dataTransfer", "Data Transfer"));
        Object[] fColumnName = new String[]{Language.getString("ethernet.ethernetConfigurePanel.dataTransfer.operate", "Operate"), Language.getString("ethernet.ethernetConfigurePanel.dataTransfer.length", "Length (Bytes)"), Language.getString("ethernet.ethernetConfigurePanel.dataTransfer.localAddress", "Address (Local)"), Language.getString("ethernet.ethernetConfigurePanel.dataTransfer.remoteAddress", "Address (Remote)")};
        DefaultTableModel model = new DefaultTableModel(fColumnName, 0);
        this.fTable = new JTable(model);
        this.fTablePanel = new DataTransferJTablePanel(this.fTable, this.fHardware.getIntProperty("dataTransferNumber"));
        this.fTablePanel.setRowHeight(20);
        this.fTablePanel.setPreferredSize(new Dimension(480, 223));
        this.fTablePanel.setColumnWidth(this.getOperateColumnIndex(), 40);
        this.fTablePanel.setColumnWidth(this.getLengthColumnIndex(), 40);
        String[] operate = new String[]{this.READ, this.WRITE};
        DefaultCellEditor operateEditor = new DefaultCellEditor(new JComboBox<String>(operate));
        operateEditor.setClickCountToStart(2);
        this.fTablePanel.setCellEditor(this.getOperateColumnIndex(), operateEditor);
        EditableNumericCellSpinner fLengthSpinner = new EditableNumericCellSpinner();
        fLengthSpinner.setMax(212);
        fLengthSpinner.setMin(1);
        fLengthSpinner.setIncrement(1);
        SpinnerCellEditor lengthCellEditor = new SpinnerCellEditor(fLengthSpinner);
        lengthCellEditor.setClickCountToStart(2);
        this.fTablePanel.setCellEditor(this.getLengthColumnIndex(), lengthCellEditor);
        TableColumn localAddress = this.fTablePanel.getTable().getColumnModel().getColumn(this.getLocalAddressColumnIndex());
        localAddress.setCellRenderer(new AddressColumnCellRender());
        localAddress.setCellEditor(new AddressColumnCellEditor(new JTextField()));
        TableColumn remoteAddress = this.fTablePanel.getTable().getColumnModel().getColumn(this.getRemoteAddressColumnIndex());
        remoteAddress.setCellRenderer(new AddressColumnCellRender());
        remoteAddress.setCellEditor(new AddressColumnCellEditor(new JTextField()));
        dataTransferPanel.add((Component)this.fTablePanel, "Center");
        return dataTransferPanel;
    }

    @Override
    public void storeFieldContents() {
        this.fEthernetConnection.setClient(this.fClientButton.isSelected());
        if (this.fClientButton.isSelected()) {
            this.fEthernetConnection.setAcceptedIP(null);
            this.fEthernetConnection.setLocalTsap(this.fClientLocalTsap.getText());
            this.fEthernetConnection.setRemoteTsap(this.fClientRemoteTsap.getText().toUpperCase());
            this.fEthernetConnection.setRemoteIP(this.fClientRemoteIP.getIP());
            JTable table = this.fTablePanel.getTable();
            this.fEthernetConnection.clearVMTransaction();
            for (int i = 0; i < table.getRowCount(); ++i) {
                Object operator = table.getValueAt(i, this.getOperateColumnIndex());
                Object length = table.getValueAt(i, this.getLengthColumnIndex());
                Object fromAddress = table.getValueAt(i, this.getLocalAddressColumnIndex());
                Object toAddress = table.getValueAt(i, this.getRemoteAddressColumnIndex());
                if (operator == null || length == null || fromAddress == null || toAddress == null) continue;
                int fromAdd = Integer.valueOf(fromAddress.toString().substring(2, fromAddress.toString().length()));
                String toAdd = toAddress.toString().toLowerCase();
                int fromDataType = this.getDataType(fromAddress.toString());
                int toDataType = this.getDataType(toAddress.toString());
                EthernetConnection.Transfer transfer = toAdd.startsWith("db") ? new EthernetConnection.Transfer(this.getOperateType(operator.toString()), fromAdd, fromDataType, Integer.valueOf(toAdd.substring(2, toAdd.indexOf(46))), Integer.valueOf(toAdd.substring(toAdd.indexOf(46) + 4, toAdd.length())), Integer.parseInt(length.toString()), true) : new EthernetConnection.Transfer(this.getOperateType(operator.toString()), fromAdd, fromDataType, Integer.parseInt(toAdd.substring(2, toAdd.length())), toDataType, Integer.parseInt(length.toString()));
                this.fEthernetConnection.addVMTransaction(transfer);
            }
        } else {
            this.fEthernetConnection.setRemoteIP(null);
            this.fEthernetConnection.setLocalTsap(this.fServerLocalTsap.getText());
            this.fEthernetConnection.setRemoteTsap(this.fServerRemoteTsap.getText().toUpperCase());
            if (this.fAcceptAllIP.isSelected()) {
                this.fEthernetConnection.setAcceptedIP("");
            } else {
                this.fEthernetConnection.setAcceptedIP(this.fAcceptedIP.getIP());
            }
        }
        this.fEthernetConnection.setAliveInterval(this.fAliveInterval.getValue());
    }

    @Override
    public void loadFieldContents() {
        while (this.fTablePanel.getTable().getRowCount() > 0) {
            this.fTablePanel.deleteRow(0);
        }
        if (this.fEthernetConnection.getRemoteTsap() == null) {
            this.iniComponentValue();
            return;
        }
        if (this.fEthernetConnection.isClient()) {
            this.fClientButton.setSelected(true);
            this.fClientLocalTsap.setText(this.fEthernetConnection.getLocalTsap());
            this.fClientRemoteTsap.setText(this.fEthernetConnection.getRemoteTsap());
            this.fClientRemoteIP.setIP(this.fEthernetConnection.getRemoteIP());
            Enumeration<EthernetConnection.Transfer> actions = this.fEthernetConnection.getVMReadTransactions().elements();
            this.loadTransaction(actions);
            actions = this.fEthernetConnection.getVMWriteTransactions().elements();
            this.loadTransaction(actions);
            this.fServerRemoteTsap.setText("");
            this.fAcceptAllIP.setSelected(false);
            this.fAcceptedIP.setEnabled(true);
            this.fAcceptedIP.setIP("");
        } else {
            this.fServerButton.setSelected(true);
            this.fServerLocalTsap.setText(this.fEthernetConnection.getLocalTsap());
            if (this.fEthernetConnection.getLocalTsap().equals(OP_TSAP)) {
                this.fOPCheckBox.setEnabled(true);
                this.fOPCheckBox.setSelected(true);
            } else {
                this.fOPCheckBox.setEnabled(!this.isOPUsed());
            }
            this.fServerRemoteTsap.setText(this.fEthernetConnection.getRemoteTsap());
            if (this.fEthernetConnection.getAcceptedIP() == null || this.fEthernetConnection.getAcceptedIP().trim().length() == 0) {
                this.fAcceptAllIP.setSelected(true);
                this.fAcceptedIP.setIP("");
            } else {
                this.fAcceptAllIP.setSelected(false);
                this.fAcceptedIP.setIP(this.fEthernetConnection.getAcceptedIP());
            }
            this.fClientRemoteTsap.setText("");
            this.fClientRemoteIP.setIP("");
        }
        if (this.fTablePanel.getTable().getRowCount() < 1) {
            this.fTablePanel.addRowIntoJTable(-1, null);
        }
        if (this.fEthernetConnection.getAliveInterval() == 0) {
            this.fEnableKeepAlive.setSelected(false);
        } else {
            this.fEnableKeepAlive.setSelected(true);
        }
        this.fAliveInterval.setValue(this.fEthernetConnection.getAliveInterval());
    }

    private void loadTransaction(Enumeration<EthernetConnection.Transfer> transaction) {
        while (transaction.hasMoreElements()) {
            EthernetConnection.Transfer transferAction = transaction.nextElement();
            String remoteDataTypeName = Global.getDataTypeName(transferAction.fRemoteDataBlockType);
            String remoteAdd = remoteDataTypeName.equals("DB") ? remoteDataTypeName + transferAction.fBlockAddress + ".DBB" + transferAction.fBlockByteAddress : remoteDataTypeName + transferAction.fRemoteAddress;
            Object[] rowData = new String[]{this.getOperateName(transferAction.fOperateCode), String.valueOf(transferAction.fLength), Global.getDataTypeName(transferAction.fLocalDataBlockType) + transferAction.fLocalAddress, remoteAdd};
            this.fTablePanel.addRowIntoJTable(-1, rowData);
        }
    }

    private void iniComponentValue() {
        this.fClientButton.setSelected(true);
        this.fClientLocalTsap.setText(EthernetConfigurePanel.getFreeLocalTsap(this.fDataVector));
        this.fClientRemoteTsap.setText("");
        this.fClientRemoteIP.resetIP();
        this.fServerRemoteTsap.setText("");
        this.fOPCheckBox.setSelected(false);
        this.fOPCheckBox.setEnabled(!this.isOPUsed());
        this.fAcceptAllIP.setSelected(false);
        this.fAcceptedIP.setEnabled(true);
        this.fAcceptedIP.resetIP();
        this.fEnableKeepAlive.setSelected(false);
        this.fAliveInterval.setValue(0);
        this.fAliveInterval.setEnabled(false);
        this.fTablePanel.addRowIntoJTable(-1, null);
    }

    public void setOPEnabled(boolean enabled) {
        this.fOPCheckBox.setEnabled(enabled);
    }

    public JCheckBox getOPCheckBox() {
        return this.fOPCheckBox;
    }

    @Override
    public boolean checkFieldContents() {
        if (this.fClientButton.isSelected()) {
            if (!this.isTSAPLegal(this.fClientRemoteTsap.getText())) {
                new LogoError(null, "ethernet.connectionConfigurePanel.illegalTsap", "You must enter a correct TSAP.", 2, 0).display();
                return false;
            }
            if (!IPAddressJTextField.isIPAddressLegal(this.fClientRemoteIP.getIP())) {
                new LogoError(null, "ethernet.ethernetConfigurePanel.wrongAddress", "Please enter a valid IP.", 2, 0).display();
                return false;
            }
            if (this.isClientServerConflict(this.fClientRemoteIP.getIP())) {
                new LogoError(null, "ethernet.ethernetConfigurePanel.clientServerConflict", "You can not specify an IP address as both slave and server, \nPlease choose another IP address.", 2, 0).display();
                return false;
            }
            if (this.sModuleIPAddress != null && !"".equals(this.sModuleIPAddress) && this.sModuleIPAddress.equals(this.fClientRemoteIP.getIP())) {
                String targetRemote = Language.getString("dialog.options.color.connection", "Connection") + String.valueOf(this.fEthernetConnection.getID());
                Object[] info = new Object[]{targetRemote};
                new LogoError(null, "ethernet.ethernetConfigurePanel.moduleIpConflictWithServerIp", "The module IP address can't be the same as the sever IP address.", info, 2, 0).display();
                return false;
            }
            JTable table = this.fTablePanel.getTable();
            for (int i = 0; i < table.getRowCount(); ++i) {
                if (table.isEditing()) {
                    table.getCellEditor().stopCellEditing();
                }
                Object operator = table.getValueAt(i, this.getOperateColumnIndex());
                Object length = table.getValueAt(i, this.getLengthColumnIndex());
                Object localAdd = table.getValueAt(i, this.getLocalAddressColumnIndex());
                Object remoteAdd = table.getValueAt(i, this.getRemoteAddressColumnIndex());
                if (operator == null && length == null && localAdd == null && remoteAdd == null) continue;
                if (operator == null || length == null || localAdd == null || remoteAdd == null) {
                    Object[] info = new Object[]{i + 1};
                    new LogoError(null, "ethernet.ipAndConnectionPanel.emptyVM", "The value in line " + (i + 1) + " must not be empty.", info, 2, 0).display();
                    return false;
                }
                int localErrorInfo = this.checkAddress(this.getOperateType(operator.toString()), Integer.valueOf(length.toString()), localAdd.toString(), true);
                int remoteErrorInfo = this.checkAddress(this.getOperateType(operator.toString()), Integer.valueOf(length.toString()), remoteAdd.toString(), false);
                if (localErrorInfo != 0) {
                    this.displayAddressErrorMessage(true, i + 1, localErrorInfo);
                    return false;
                }
                if (remoteErrorInfo == 0) continue;
                this.displayAddressErrorMessage(false, i + 1, remoteErrorInfo);
                return false;
            }
        } else {
            if (!this.isTSAPLegal(this.fServerRemoteTsap.getText())) {
                new LogoError(null, "ethernet.connectionConfigurePanel.illegalTsap", "You must enter a correct TSAP.", 2, 0).display();
                return false;
            }
            if (!this.fAcceptAllIP.isSelected() && !IPAddressJTextField.isIPAddressLegal(this.fAcceptedIP.getIP())) {
                new LogoError(null, "ethernet.ipAndConnectionPanel.wrongAddressInConnection", "You must enter a correct IP.", 2, 0).display();
                return false;
            }
            if (this.sModuleIPAddress != null && !"".equals(this.sModuleIPAddress) && this.sModuleIPAddress.equals(this.fAcceptedIP.getIP())) {
                String targetRemote = Language.getString("dialog.options.color.connection", "Connection") + String.valueOf(this.fEthernetConnection.getID());
                Object[] info = new Object[]{targetRemote};
                new LogoError(null, "ethernet.ethernetConfigurePanel.moduleIpConflictWithAcceptIp", "The module IP address can't be the same as the accept IP address.", info, 2, 0).display();
                return false;
            }
        }
        return true;
    }

    private boolean isClientServerConflict(String ip) {
        for (EthernetConnection conn : this.fDataVector) {
            if (conn.getLocalTsap() == null || conn == this.fEthernetConnection || !conn.isForSlave() || !ip.equals(conn.getRemoteIP())) continue;
            return true;
        }
        return false;
    }

    private int getOperateColumnIndex() {
        return 0;
    }

    private int getLengthColumnIndex() {
        return 1;
    }

    private int getLocalAddressColumnIndex() {
        return 2;
    }

    private int getRemoteAddressColumnIndex() {
        return 3;
    }

    private boolean isTSAPLegal(String tsap) {
        String tsapPattern = "[0-9[A-E][a-e]][\\d[A-F][a-f]][.][\\d[A-F][a-f]]{2}";
        Pattern pattern = Pattern.compile(tsapPattern);
        Matcher matcher = pattern.matcher(tsap);
        return matcher.matches();
    }

    private int getOperateType(String operateName) {
        if (operateName.equals(this.READ)) {
            return 0;
        }
        return 1;
    }

    private String getOperateName(int operateType) {
        if (operateType == 0) {
            return this.READ;
        }
        return this.WRITE;
    }

    private boolean isOPUsed() {
        for (EthernetConnection connection : this.fDataVector) {
            if (connection.getLocalTsap() == null || !connection.getLocalTsap().equals(OP_TSAP)) continue;
            return true;
        }
        return false;
    }

    private void displayAddressErrorMessage(boolean local, int row, int errorInfo) {
        String destination = local ? "local" : "remote";
        if (errorInfo == 2) {
            Object[] info = new Object[]{destination, row};
            new LogoError(null, "ethernet.connectionConfigurePanel.addOutofRange", "The address exceed the maximum.", info, 2, 0).display();
        } else if (errorInfo == 3) {
            Object[] info = new Object[]{destination, row};
            new LogoError(null, "ethernet.connectionConfigurePanel.wrongTransferredArea", "The transfered address area is out of range.", info, 2, 0).display();
        } else if (errorInfo == 1) {
            Object[] info = new Object[]{destination, row};
            new LogoError(null, "ethernet.connectionConfigurePanel.wrongAddress", "The address is not correct.", info, 2, 0).display();
        }
    }

    private String getLocalNextAddress(int insertRow) {
        if (insertRow == 0) {
            return "";
        }
        String previousLocalAddress = "";
        if (this.fTable.getValueAt(insertRow - 1, this.getLocalAddressColumnIndex()) != null) {
            previousLocalAddress = this.fTable.getValueAt(insertRow - 1, this.getLocalAddressColumnIndex()).toString();
        }
        int previousLength = 0;
        if (this.fTable.getValueAt(insertRow - 1, this.getLengthColumnIndex()) != null) {
            previousLength = Integer.valueOf(this.fTable.getValueAt(insertRow - 1, this.getLengthColumnIndex()).toString());
        }
        return this.getNextAddress(previousLocalAddress, previousLength, true);
    }

    private String getRemoteNextAddress(int insertRow) {
        if (insertRow == 0) {
            return "";
        }
        String previousRemoteAddress = "";
        if (this.fTable.getValueAt(insertRow - 1, this.getRemoteAddressColumnIndex()) != null) {
            previousRemoteAddress = this.fTable.getValueAt(insertRow - 1, this.getRemoteAddressColumnIndex()).toString();
        }
        int previousLength = 0;
        if (this.fTable.getValueAt(insertRow - 1, this.getLengthColumnIndex()) != null) {
            previousLength = Integer.valueOf(this.fTable.getValueAt(insertRow - 1, this.getLengthColumnIndex()).toString());
        }
        return this.getNextAddress(previousRemoteAddress, previousLength, false);
    }

    private String getNextAddress(String address, int length, boolean isLocalAddress) {
        String nextAddress = "";
        if (address == null || address.equals("")) {
            return "VB0";
        }
        String lowerAddress = address.toLowerCase();
        String reg = "[Dd][Bb][0-9]+.[Dd][Bb]{2}[0-9]+";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(address);
        boolean matched = matcher.matches();
        if (matched) {
            int blockAdd = 0;
            int byteAdd = 0;
            try {
                if (lowerAddress.indexOf(46) != -1) {
                    blockAdd = Integer.valueOf(lowerAddress.substring(2, lowerAddress.indexOf(46)));
                    byteAdd = Integer.valueOf(lowerAddress.substring(lowerAddress.indexOf(46) + 4, lowerAddress.length()));
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            nextAddress = byteAdd + length > 65535 ? (blockAdd + 1 > 16000 ? "DB1.DBB0" : "DB" + String.valueOf(blockAdd + 1) + ".DBB0") : "DB" + String.valueOf(blockAdd) + ".DBB" + String.valueOf(byteAdd + length);
        } else {
            int add = 0;
            try {
                add = Integer.valueOf(lowerAddress.substring(2, lowerAddress.length()));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (!(lowerAddress.startsWith("vb") || lowerAddress.startsWith("qb") || lowerAddress.startsWith("ib") || lowerAddress.startsWith("mb"))) {
                return "VB0";
            }
            int size = this.getMaxAddress(address, isLocalAddress);
            String vmType = lowerAddress.substring(0, 2);
            nextAddress = add + length > size ? vmType.toUpperCase() + "0" : vmType.toUpperCase() + String.valueOf(add + length);
        }
        return nextAddress;
    }

    private String getNextOperate(int insertRow) {
        if (this.fTable.getValueAt(insertRow - 1, this.getOperateColumnIndex()) == null) {
            return this.READ;
        }
        return this.fTable.getValueAt(insertRow - 1, this.getOperateColumnIndex()).toString();
    }

    private int checkAddress(int op, int length, String address, boolean isLocalAddress) {
        if (this.checkPattern(op, address, isLocalAddress)) {
            int add;
            String lowerAddress = address.toLowerCase();
            if (lowerAddress.startsWith("db")) {
                try {
                    int blockAdd = Integer.valueOf(lowerAddress.substring(2, lowerAddress.indexOf(46)));
                    int byteAdd = Integer.valueOf(lowerAddress.substring(lowerAddress.indexOf(46) + 4, lowerAddress.length()));
                    if (blockAdd > 0 && blockAdd <= 16000 && byteAdd <= 65535) {
                        if (byteAdd + length > 65536) {
                            return 3;
                        }
                        return 0;
                    }
                    return 2;
                }
                catch (NumberFormatException e) {
                    return 2;
                }
            }
            try {
                add = Integer.valueOf(lowerAddress.substring(2, lowerAddress.length()));
            }
            catch (NumberFormatException e) {
                return 2;
            }
            int maxAddress = this.getMaxAddress(lowerAddress, isLocalAddress);
            if (add <= maxAddress) {
                if (add + length > maxAddress + 1) {
                    return 3;
                }
                return 0;
            }
            return 2;
        }
        return 1;
    }

    private boolean checkPattern(int op, String address, boolean isLocalAddress) {
        String rex = op == 0 ? (isLocalAddress ? "[Vv][Bb][0-9]+" : "([VvQqIiMm][Bb][0-9]+)|([Dd][Bb][0-9]+.[Dd][Bb]{2}[0-9]+)") : (isLocalAddress ? "[VvQqIiMm][Bb][0-9]+" : "([VvQqIiMm][Bb][0-9]+)|([Dd][Bb][0-9]+.[Dd][Bb]{2}[0-9]+)");
        Pattern pattern = Pattern.compile(rex);
        Matcher matcher = pattern.matcher(address);
        return matcher.matches();
    }

    private int getDataType(String address) {
        int dataType = address.toLowerCase().startsWith("ib") ? 2 : (address.toLowerCase().startsWith("qb") ? 3 : (address.toLowerCase().startsWith("mb") ? 4 : (address.toLowerCase().startsWith("db") ? 1 : 0)));
        return dataType;
    }

    private String correctAddress(String address, int length, boolean isLocalAddress) {
        StringBuffer corrected = new StringBuffer("");
        String lowerAddress = address.toLowerCase();
        if (lowerAddress.startsWith("db")) {
            int byteAdd;
            int blockAdd;
            try {
                blockAdd = Integer.valueOf(lowerAddress.substring(2, lowerAddress.indexOf(46)));
            }
            catch (NumberFormatException e) {
                blockAdd = Integer.MAX_VALUE - length;
            }
            try {
                byteAdd = Integer.valueOf(lowerAddress.substring(lowerAddress.indexOf(46) + 4, lowerAddress.length()));
            }
            catch (NumberFormatException e) {
                byteAdd = Integer.MAX_VALUE - length;
            }
            if (blockAdd > 16000) {
                blockAdd = 16000;
            }
            if (blockAdd == 0) {
                blockAdd = 1;
            }
            if (byteAdd + length > 65535 && 65536 - length > 0) {
                byteAdd = 65536 - length;
            }
            corrected.append("db").append(blockAdd).append(".dbb").append(byteAdd);
        } else {
            int add;
            try {
                add = Integer.valueOf(lowerAddress.substring(2, lowerAddress.length()));
            }
            catch (NumberFormatException e) {
                add = Integer.MAX_VALUE - length;
            }
            int maxAddress = this.getMaxAddress(address, isLocalAddress);
            if (add + length > maxAddress + 1) {
                corrected.append(lowerAddress.substring(0, 2)).append(maxAddress + 1 - length > 0 ? maxAddress + 1 - length : add);
            }
        }
        return corrected.toString();
    }

    private String removeLeadingZero(int op, String address, boolean isLocalAddress) {
        if (!this.checkPattern(op, address, isLocalAddress)) {
            return address;
        }
        StringBuffer removed = new StringBuffer("");
        String lowerAddress = address.toLowerCase();
        if (lowerAddress.startsWith("db")) {
            int byteAdd;
            int blockAdd;
            try {
                blockAdd = Integer.valueOf(lowerAddress.substring(2, lowerAddress.indexOf(46)));
                byteAdd = Integer.valueOf(lowerAddress.substring(lowerAddress.indexOf(46) + 4, lowerAddress.length()));
            }
            catch (NumberFormatException e) {
                return address;
            }
            removed.append("db");
            removed.append(blockAdd);
            removed.append(lowerAddress.substring(lowerAddress.indexOf(46), lowerAddress.indexOf(46) + 4));
            removed.append(byteAdd);
        } else {
            int add;
            try {
                add = Integer.valueOf(lowerAddress.substring(2, lowerAddress.length()));
            }
            catch (NumberFormatException e) {
                return address;
            }
            removed.append(lowerAddress.substring(0, 2));
            removed.append(add);
        }
        return removed.toString();
    }

    private int getMaxAddress(String address, boolean isLocalAddress) {
        int maxAddress = 0;
        if (address == null || address.equals("")) {
            return maxAddress;
        }
        String lowerAddress = address.toLowerCase();
        if (isLocalAddress) {
            if (lowerAddress.startsWith("vb")) {
                maxAddress = this.fVMSize - 1;
            } else if (lowerAddress.startsWith("qb")) {
                maxAddress = this.fHardware.getIntProperty("aqStartAddress") - this.fHardware.getIntProperty("qStartAddress") - 1;
            } else if (lowerAddress.startsWith("ib")) {
                maxAddress = this.fHardware.getIntProperty("aiStartAddress") - this.fHardware.getIntProperty("iStartAddress") - 1;
            } else if (lowerAddress.startsWith("mb")) {
                maxAddress = this.fHardware.getIntProperty("amStartAddress") - this.fHardware.getIntProperty("mStartAddress") - 1;
            }
        } else if (lowerAddress.startsWith("vb") || lowerAddress.startsWith("qb") || lowerAddress.startsWith("ib") || lowerAddress.startsWith("mb")) {
            maxAddress = 65535;
        }
        return maxAddress;
    }

    @Override
    public String getHelpIdString() {
        StringBuffer buffer = new StringBuffer("dialog.connectionConfigure.");
        if (this.fClientButton.isSelected()) {
            buffer.append("ClientConnection");
        } else {
            buffer.append("ServerConnection");
        }
        return buffer.toString();
    }

    class DataTransferJTablePanel
    extends IndexedJTablePanel {
        public DataTransferJTablePanel(JTable table, int maxTableLine) {
            super(table, maxTableLine);
        }

        protected void insertAfterCurrentRow(int selectedRow) {
            int insertRow = selectedRow + 1;
            Object[] data = new Object[]{ConnectionConfigurePanel.this.getNextOperate(insertRow), 1, ConnectionConfigurePanel.this.getLocalNextAddress(insertRow), ConnectionConfigurePanel.this.getRemoteNextAddress(insertRow)};
            this.addRowIntoJTable(insertRow, data);
            ConnectionConfigurePanel.this.fTable.setRowSelectionInterval(insertRow, insertRow);
            ConnectionConfigurePanel.this.fTable.setColumnSelectionInterval(0, ConnectionConfigurePanel.this.fTable.getColumnCount() - 1);
            Rectangle rect = ConnectionConfigurePanel.this.fTable.getCellRect(insertRow, 0, true);
            ConnectionConfigurePanel.this.fTable.scrollRectToVisible(rect);
        }
    }

    class AddressColumnCellEditor
    extends DefaultCellEditor {
        public AddressColumnCellEditor(JTextField component) {
            super(component);
        }

        public boolean stopCellEditing() {
            Object value = ConnectionConfigurePanel.this.fTable.getValueAt(ConnectionConfigurePanel.this.fTable.getEditingRow(), ConnectionConfigurePanel.this.getLengthColumnIndex());
            Object op = ConnectionConfigurePanel.this.fTable.getValueAt(ConnectionConfigurePanel.this.fTable.getEditingRow(), ConnectionConfigurePanel.this.getOperateColumnIndex());
            if (value != null && op != null) {
                ((JTextField)this.getComponent()).setText(ConnectionConfigurePanel.this.removeLeadingZero(ConnectionConfigurePanel.this.getOperateType(op.toString()), this.getCellEditorValue().toString(), ConnectionConfigurePanel.this.getLocalAddressColumnIndex() == ConnectionConfigurePanel.this.fTable.getEditingColumn()));
                int addressChk = ConnectionConfigurePanel.this.checkAddress(ConnectionConfigurePanel.this.getOperateType(op.toString()), Integer.valueOf(value.toString()), this.getCellEditorValue().toString(), ConnectionConfigurePanel.this.getLocalAddressColumnIndex() == ConnectionConfigurePanel.this.fTable.getEditingColumn());
                if (addressChk == 0) {
                    ((JTextField)this.getComponent()).setText(this.getCellEditorValue().toString().toUpperCase());
                } else if (addressChk == 2) {
                    ((JTextField)this.getComponent()).setText(ConnectionConfigurePanel.this.correctAddress(this.getCellEditorValue().toString(), Integer.valueOf(value.toString()), ConnectionConfigurePanel.this.getLocalAddressColumnIndex() == ConnectionConfigurePanel.this.fTable.getEditingColumn()).toUpperCase());
                }
            }
            return super.stopCellEditing();
        }
    }

    class AddressColumnCellRender
    extends DefaultTableCellRenderer {
        AddressColumnCellRender() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object length = ConnectionConfigurePanel.this.fTable.getValueAt(row, ConnectionConfigurePanel.this.getLengthColumnIndex());
            Object op = table.getValueAt(row, ConnectionConfigurePanel.this.getOperateColumnIndex());
            if (length == null || op == null) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            int len = Integer.valueOf(length.toString());
            if (value == null || ConnectionConfigurePanel.this.checkAddress(ConnectionConfigurePanel.this.getOperateType(op.toString()), len, value.toString(), ConnectionConfigurePanel.this.getLocalAddressColumnIndex() == column) == 0) {
                this.setForeground(Color.BLACK);
            } else {
                this.setForeground(Color.RED);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

